<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ext_shopify_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('shopify_store_id')->constrained('ext_shopify_stores')->onDelete('cascade');
            $table->unsignedBigInteger('shopify_product_id');
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('handle')->nullable();
            $table->string('product_type')->nullable();
            $table->string('vendor')->nullable();
            $table->decimal('price', 10, 2)->default(0);
            $table->decimal('compare_at_price', 10, 2)->nullable();
            $table->integer('inventory_quantity')->default(0);
            $table->string('inventory_policy')->nullable();
            $table->text('image_url')->nullable();
            $table->json('images')->nullable();
            $table->json('variants')->nullable();
            $table->string('status')->default('active');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index('shopify_store_id');
            $table->index('shopify_product_id');
            $table->index('status');
            $table->unique(['shopify_store_id', 'shopify_product_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ext_shopify_products');
    }
};
